<?php
error_reporting (E_ERROR | E_WARNING | E_PARSE);
/*
Envoi de formulaire sans javascript avec pice jointe propos par Pierre Pesty http://dev.ppan.net/

Variables A MODIFIER selon vos besoins :
*/
# remplacez login@fai par votre email
$destinataire = "login@fai";
# nom et titre de page
$pageName = "Formulaire de contact";
# en-tte de l'objet du mail (option: vide)
$entete = "[dev.ppan.net]";
# envoi en copie carbone (option: vide)
$email_cc = "";
# envoi en copie cache (option: vide)
$email_bcc = "";
# emplacement de la feuille de styles
$cssform = "webdev_form.css";
# nom du rpertoire pour upload des pices jointes
# le rpertoire (ici "upload") doit tre cr sur le serveur
$rep = "upload/"; // ne pas oublier le slash /
# taille max de la pice jointe (multiple de 1024)
$taillemax = 204800;
# menu droulant pour l'objet (option: vide)
# ajout d'option : 'n'=>'Choix 1', 'n+1'=>'Choix 2', etc.
# la premire ligne (optionnelle) impose un choix
$objets = array(
    0 => 'Choisissez',
    1 => 'Test du script',
    2 => 'Ce script',
    3 => 'Autre',
);
# page vers laquelle rediriger le script aprs envoi russi
$pageconfirme = "index.php";
# traiter $_GET['mailOK'] dans $pageconfirme (ex. index.php) comme ceci :
# if(isset($_GET['mailOK'])) echo "Votre message a t envoy";
/*
fin des modifications
*/

$erreur = false;
$message = false;
$focus = 0;

# l'utilisateur a valid le formulaire
if (!empty($_POST)) {

	# vrification des champs requis (Nom, Objet, Message, Email ou Tel)
	if (empty($_POST['Message'])) {
		$erreur = "Merci de renseigner le message";
		$focus = 1; // modification couleur du champ de saisie concern
	}
	if (empty($_POST['Objet'])) {
		$erreur = "Merci de renseigner l'objet";
		$focus = 2;
	}
	if (empty($_POST['Nom'])) {
		$erreur = "Merci de renseigner votre nom";
		$focus = 3;
	}
	# email et tel sont vides : pas glop !
	if (empty($_POST['Email']) && empty($_POST['Tel'])) {
		$erreur = "Saisir email et/ou t&eacute;l&eacute;phone SVP";
		$focus = 4;
	}
	# vrification de l'email non vide
	elseif (!empty($_POST['Email'])) {
		if(!preg_match('`^[[:alnum:]]([-_.]?[[:alnum:]])*@[[:alnum:]]([-_.]?[[:alnum:]])*\.([a-z]{2,4})$`',$_POST['Email'])) {
			$erreur = "Email non conforme";
			$_POST['Email'] = "";
			$focus = 5;
		}
	# vrification du tlphone (sans espaces)
	} elseif (!is_numeric(str_replace(" ","",$_POST['Tel']))) {
		$erreur = "Tlphone non conforme";
		$_POST['Tel'] = "";
		$focus = 6;
	}
	# pice jointe (nouveaut 12.10.2005)
	$piecejointe = "";
	if(!$erreur && strlen($_FILES['Fichier']['name'])) {
		$fichier = $_FILES['Fichier'];
		# upload du fichier sur le serveur
		$temp = $fichier['tmp_name'];
		$name = $fichier['name'];
		$size = $fichier['size'];
		$destination = $rep.$name;
		if($size > $taillemax)
			$erreur = "Taille du fichier $name > ".(int)($taillemax/1024)." Ko";
		elseif(!@is_uploaded_file($temp))
			$erreur = "Tlchargement du fichier $name impossible";
		elseif(!@move_uploaded_file($temp, $destination))
			$erreur = "Problme de transfert du fichier $name";
		if($erreur) $focus = 7;
		else {
			# lecture du type de fichier
			if(!function_exists('mime_content_type')) {
				function mime_content_type($fichier) {
					# ajouter autant de combinaisons que souhaites
					$mime = array(
					'.gif' => 'image/gif',
					'.jpg' => 'image/jpeg',
					'.psd' => 'image/x-xwd',
					'.png' => 'image/png',
					'.txt' => 'text/plain',
					'.doc' => 'application/msword',
					'.xls' => 'application/vnd.ms-excel',
					);
					# par dfaut
					if(!$type = $mime[strrchr($fichier,'.')]) $type = "application/octet-stream";
					return $type;
				}
			}
			/*
				pour utiliser mime_content_type()
				diter le fichier php.ini et enlever le commentaire sur :
				extension=php_mime_magic.dll
				sous Windows ajouter ces 2 lignes :
				mime_magic.debug = On
				mime_magic.magicfile = "c:\chemin_du_fichier\magic.mime"
				NB : fonction non active chez OVH
			*/
			$mimetype = mime_content_type($destination);
			# lecture et conversion du fichier
			if($openf = @fopen($destination, "rb")) {
				$fichier = fread($openf, filesize($destination));
				@fclose($openf);
				# encodage norme RFC 2045
				$piecejointe = chunk_split(base64_encode($fichier));
			} else {
				$erreur = "Problme de lecture du fichier $name";
				$focus = 7;
			}
		}
	
	}
	# pas d'erreur donc on continue
	if(!$erreur) {

		# traitement du tableau $_POST qui contient les paires name => value
		$message_final = "";
		foreach($_POST as $key => $value) {
			# la boucle passe les champs vides ou non dsirs
			# pour passer d'autres champs les sparer par |
			if (!strlen($value) || eregi("(MAX_FILE_SIZE|Objet)", $key)) continue;
			$message_final .= "$key : ".strip_tags($value)."\n";
		}
		# formatage du message de confirmation affich (option)
		# conversion des sauts de ligne et des caractres spciaux
		$message = ereg_replace("(\n|\r|\r\n)", "<br>", htmlentities($message_final));
		# si $objets est un tableau : Objet = select donc index = $_POST['Objet']
		if(is_array($objets))
			$objet = "$entete ".$objets[$_POST['Objet']];
		# sinon Objet = input donc en franais dans le texte !
		else
			$objet = "$entete ".$_POST['Objet'];
		# si l'email n'est pas renseign on le remplace par celui
		# du destinataire, en ajoutant une alerte au message
		$final_mail = $_POST['Email'];
		if(empty($_POST['Email'])) {
			$final_mail = $destinataire;
			$message_final .= "\nNe pas rpondre par mail : email absent.\n";
		}
		# en-ttes
		$headers = "From: ".$final_mail;
		if(strlen($email_cc))
			$headers .= "\nCC: ".$email_cc;
		if(strlen($email_bcc))
			$headers .= "\nBCC: ".$email_bcc;
		# hte expditeur
		$message_final .= "Hte : ".gethostbyaddr($_SERVER['REMOTE_ADDR']);
		# si pice jointe on ajoute l'en-tte spcifique avec sparateurs
		if(strlen($piecejointe)) {
			$boundary = "/-------".md5(uniqid(rand()))."-------/"; // sparateur
			$headers .= "\nMIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"$boundary\"\n";
			$message_final =
				"This is a multi-part message in MIME format.\n--$boundary\n".
				"Content-Type: text/plain; charset=ISO-8859-1\n".
				"Content-Transfer-Encoding: 7bit\n\n".
				"$message_final\n\n--$boundary\n".
				"Content-Type: $mimetype; name=\"$name\"\n".
				"Content-Transfer-Encoding: base64\n".
				"Content-Disposition: attachment; filename=\"$name\"\n\n".
				"$piecejointe\n--".
				$boundary."--\n";
		}

		# envoi du mail
		if (@mail($destinataire, stripslashes($objet), stripslashes($message_final), $headers)) {
			@unlink($destination); // suppression de la pice jointe
			@header("Location: ".$pageconfirme."?mailOK=1");
			exit;
		 } else {
			$pageName = "Echec !";
			$erreur = "Echec de l'envoi ! Merci d'essayer encore";
		 }

	} else {

		$pageName = "Erreur de saisie !";

	} // if(!$erreur)

} // if ($_POST)
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title><? echo $pageName?></title>
<meta name="author" content="Pierre Pesty">
<meta name="generator" content="http://dev.ppan.net/">
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link href="<? echo $cssform?>" type="text/css" rel="stylesheet">
</head>
<body>
	<div>
<?		if (!$erreur) { ?>
		  <h4>Contact</h4>
		  <p>Merci de renseigner les champs marqus d'un astrisque (email et/ou tlphone)</p>
<?		} else { ?>
		  <p class="alerte"><? echo $erreur?></p>
<?		} ?>
		  <hr>
		  <form name="formulaire" action="<? echo $_SERVER['PHP_SELF']?>" method="post" enctype="multipart/form-data">
			 <p>
				<label for="nom">Nom</label><input id="nom" <? if($focus == 3) echo "class=\"focus\"";?> name="Nom" maxlength="30" value="<? echo htmlentities($_POST['Nom'], ENT_QUOTES)?>"> 
			 </p>
			 <p>
				<label for="email">Email</label><input id="email" <? if($focus == 5 || $focus == 4) echo "class=\"focus\"";?> name="Email" maxlength="60" value="<? echo htmlentities($_POST['Email'], ENT_QUOTES)?>">
			 </p>
			 <p>
				<label for="tel">Tlphone</label><input id="tel" <? if($focus == 6 || $focus == 4) echo "class=\"focus\"";?> name="Tel" maxlength="20" value="<? echo htmlentities($_POST['Tel'])?>">
			 </p>
			 <p>
<?		if (is_array($objets)) { ?>
				<label for="objet">Objet</label><select name='Objet' <? if($focus == 2) echo "class=\"focus\"";?> id="objet">
<?
foreach($objets as $key => $val) {
    echo "				  <option value='$key'";
    // vrifier si une des entres a t choisie
    if($key == $_POST['Objet']) echo " selected";
    echo ">$val\n";
}
?>
				</select>
<?		} else { ?>
				<label for="objet">Objet</label><input id="objet" <? if($focus == 2) echo "class=\"focus\"";?> name="Objet" maxlength="60" value="<? echo htmlentities($_POST['Objet'], ENT_QUOTES)?>">
<?		} ?>
			 </p>
			 <p>
				<label for="message">Message</label><textarea <? if($focus == 1) echo "class=\"focus\"";?> id="message" name="Message"><? echo htmlentities(stripslashes($_POST['Message']))?></textarea>
			 </p>
<?		if (file_exists($rep)) { ?>
			 <p>
				<label for="fichier">Pice jointe</label><input type="hidden" name="MAX_FILE_SIZE" value="<? echo $taillemax?>"><input type="file" id="fichier" <? if($focus == 7) echo "class=\"focus\"";?> name="Fichier" size="35">
			 </p>
			 <p>
				<label>&nbsp;</label>NB : taille du fichier infrieure  <?= (int)($taillemax/1024)?> Ko
			 </p>
<?		} ?>
			 <p>
				<label>&nbsp;</label><input id="submit" type="submit" value="Envoyer"> <a href="./">Accueil</a>
			 </p>
		  </form>
	</div>
</body>
</html>